# .bash_profile

# Get the aliases and functions
if [ -f ~/.bashrc ]; then
        . ~/.bashrc
fi

# User specific environment and startup programs
PATH=$PATH:$HOME/bin 

# Domain names to be used
DOMAIN_NAME="services.dev"
export DOMAIN_NAME

# Directory where the software to be installed is located
SOFTWARE_DIRECTORY="/installs"
export SOFTWARE_DIRECTORY
 
# The scripts create files that are placed in this directory
TEMPORARY_DIRECTORY="${SOFTWARE_DIRECTORY}/files"
export TEMPORARY_DIRECTORY

# Base location where installs are located.
BASE_TOOLS_URL=http://vapcpappmhvcm82.tmc.va.gov/tools
export BASE_TOOLS_URL
 
# Name of the WebLogic file
WEBLOGIC_FILE_NAME="fmw_12.1.3.0.0_wls.jar"
export WEBLOGIC_FILE_NAME
 
# Base directory
BASE_DIRECTORY="/u01/app"
export BASE_DIRECTORY
 
# Directory that will used for the installation and configuration
RUNTIME_HOME="${BASE_DIRECTORY}/oracle"
export RUNTIME_HOME
 
# Directory where the JVM will be installed
JAVA_HOME="JDK_INSTALL_LOCATION"
export JAVA_HOME
 
# Directory that will be used as the middleware home (holds software binaries)
MIDDLEWARE_HOME="${RUNTIME_HOME}/fmw1213"
export MIDDLEWARE_HOME
 
# Depending on the WebLogic version to be installed, edit the wlserver_major.minor version
WEBLOGIC_HOME="${MIDDLEWARE_HOME}/wlserver"
export WEBLOGIC_HOME

# Home for Oracle Common 
ORACLE_COMMON_HOME="${WEBLOGIC_HOME}"
export ORACLE_COMMON_HOME
 
# Depending on the Coherence version to be installed, edit the coherence_major.minor version
COHERENCE_HOME="${MIDDLEWARE_HOME}/coherence"
export COHERENCE_HOME
 
# Directory where the fusion middleware software will be installed
FUSION_MIDDLEWARE_HOME="${MIDDLEWARE_HOME}/oracle_common"
export FUSION_MIDDLEWARE_HOME
 
# Location of the Oracle inventory
ORACLE_INVENTORY_HOME="${RUNTIME_HOME}/oraInventory"
export ORACLE_INVENTORY_HOME
 
# Group under which the software needs to be installed
ORACLE_INSTALL_GROUP="weblogic"
export ORACLE_INSTALL_GROUP
 
# Directory where the configuration will be placed
CONFIGURATION_HOME="${BASE_DIRECTORY}"
export CONFIGURATION_HOME

# Location of environment custom properties
CUSTOM_PROPERTIES=~/$DOMAIN_NAME.properties
export CUSTOM_PROPERTIES

# Update the path for the user
export PATH=$JAVA_HOME/bin:$PATH

# Create handly aliases that I like!
alias ll="ls -la" 
